/*:
 * @plugindesc スイッチで右クリック（キャンセル操作）を無効化します。
 * @author hisamon
 *
 * @param Switch ID
 * @type number
 * @min 1
 * @desc このスイッチがONのとき右クリックが無効化されます。
 * @default 10
 *
 * @help
 * スイッチIDで右クリック（TouchInputのキャンセル操作）を無効化します。
 *
 * スイッチがONのとき、右クリックしてもキャンセル動作は実行されません。
 * OFFに戻すと、右クリックが復活します。
 *
 * プラグインコマンドは不要です。
 */

(() => {
  const pluginName = "DisableRightClickSwitch";
  const parameters = PluginManager.parameters(pluginName);
  const switchId = Number(parameters["Switch ID"] || 10);

  const _TouchInput_onRightButtonDown = TouchInput._onRightButtonDown;

  TouchInput._onRightButtonDown = function(event) {
    if ($gameSwitches && $gameSwitches.value(switchId)) {
      // 無効化中なら何もしない
      return;
    } else {
      _TouchInput_onRightButtonDown.call(this, event);
    }
  };
})();